package java.game.cars;

import java.game.*;
import java.util.*;
import java.game.parts.*;
import java.game.parts.enginepart.airfueldeliverysystem.*;

public class Furrano_chassis extends Furrano_models
{
	public Furrano_chassis( int id )
	{
		super( id );
		carCategory = PACKAGE;

		vehicleName = vendorName = "Furrano";
		name = getName();
		
		rID_blueprint = cars.cat_04.Furrano:0x0181r;
		defColorIndex = GameLogic.CARCOLOR_RED;
		
		game_version = 2.31;
		ban_mufflers = own_suspension = allow_missing_seats = 1;

		value = 44990;
 
		fully_stripped_drag = 0.45;
		min_drag = 0.349;
		drag_reduction_mul = 0.5;
		
		parts_shop_sml = new int[2];
		parts_shop_sml[0] = cars.cat_04.Furrano:0x01B8r; //Left taillight dark
		parts_shop_sml[1] = cars.cat_04.Furrano:0x01C5r; //Right taillight dark
		
		parts_shop_big = new int[1];
		parts_shop_big[0] = cars.cat_04.Furrano:0x0114r; //Left exhaust
	}

	public void addStockParts( Descriptor desc )
	{
		int actcolor = desc.color;
		float optical = desc.optical;
		float power = desc.power;
		
		super.addStockParts( actcolor, optical, power );

		float part_random;

		randomize( optical + power );

		// parts that have only one appearance //
		if ( optical >= 1.0 )
		{
			addPart( cars.cat_04.furrano:0x000000B1r, "F windshield", actcolor, optical, power );
			addPart( cars.cat_04.furrano:0x000000C9r, "FL door", actcolor, optical, power );
			addPart( cars.cat_04.furrano:0x000000B3r, "FL seat", actcolor, optical, power );
			addPart( cars.cat_04.furrano:0x000000C0r, "FR door", actcolor, optical, power );
			addPart( cars.cat_04.furrano:0x000000CBr, "FR seat", actcolor, optical, power );
			addPart( cars.cat_04.furrano:0x000000D1r, "targa top", actcolor, optical, power );
			addPart( cars.cat_04.furrano:0x000000BDr, "trunk", actcolor, optical, power );
			addPart( cars.cat_04.furrano:0x00000114r, "muffler", actcolor, optical, power );
			addPart( cars.cat_04.furrano:0x000000BBr, "L ram air intake", actcolor, optical, power );
			addPart( cars.cat_04.furrano:0x000000BEr, "R ram air intake", actcolor, optical, power );
		} else
		{
			if ( optical >= random() ) addPart( cars.cat_04.furrano:0x000000B1r, "F windshield", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_04.furrano:0x000000C9r, "FL door", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_04.furrano:0x000000B3r, "FL seat", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_04.furrano:0x000000C0r, "FR door", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_04.furrano:0x000000CBr, "FR seat", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_04.furrano:0x000000D1r, "targa top", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_04.furrano:0x000000BDr, "trunk", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_04.furrano:0x00000114r, "muffler", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_04.furrano:0x000000BBr, "L ram air intake", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_04.furrano:0x000000BEr, "R ram air intake", actcolor, optical, power );
		}

		// parts that have multiple appearance //
		if ( optical <= 1.0 )
		{
			if ( optical >= random() ) addPart( cars.cat_04.furrano:0x000000B0r, "F bumper", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_04.furrano:0x000000CEr, "L sideskirt", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_04.furrano:0x000000C7r, "R bumper", actcolor, optical, power );
			if ( optical >= random() ) addPart( cars.cat_04.furrano:0x000000CCr, "R sideskirt", actcolor, optical, power );
		} else
		{
			part_random = random();
			if ( (optical-1)*part_random >= 0.66667 ) addPart( cars.cat_04.furrano:0x0000A0CDr, "L sideskirt 3", actcolor, optical, power ); else
			if ( (optical-1)*part_random >= 0.33333 ) addPart( cars.cat_04.furrano:0x000000CDr, "L sideskirt 2", actcolor, optical, power ); else
			addPart( cars.cat_04.furrano:0x000000CEr, "L sideskirt", actcolor, optical, power );

			if ( (optical-1)*part_random >= 0.66667 ) addPart( cars.cat_04.furrano:0x0000A0CFr, "R sideskirt 3", actcolor, optical, power ); else
			if ( (optical-1)*part_random >= 0.33333 ) addPart( cars.cat_04.furrano:0x000000CFr, "R sideskirt 2", actcolor, optical, power ); else
			addPart( cars.cat_04.furrano:0x000000CCr, "R sideskirt", actcolor, optical, power );

			part_random = random();
			if ( (optical-1)*part_random >= 0.66667 ) addPart( cars.cat_04.furrano:0x0000A0C4r, "F bumper 3", actcolor, optical, power ); else
			if ( (optical-1)*part_random >= 0.33333 ) addPart( cars.cat_04.furrano:0x000000C4r, "F bumper 2", actcolor, optical, power ); else
			addPart( cars.cat_04.furrano:0x000000B0r, "F bumper", actcolor, optical, power );

			part_random = random();
			if ( (optical-1)*part_random >= 0.66667 ) addPart( cars.cat_04.furrano:0x0000A0B9r, "R bumper 3", actcolor, optical, power ); else
			if ( (optical-1)*part_random >= 0.33333 ) addPart( cars.cat_04.furrano:0x000000B9r, "R bumper 2", actcolor, optical, power ); else
			addPart( cars.cat_04.furrano:0x000000C7r, "R bumper", actcolor, optical, power );
		}

		addPart( cars.cat_04.furrano:0x000001FFr, "FL suspension" );
		addPart( cars.cat_04.furrano:0x00000200r, "FR suspension" );
		addPart( cars.cat_04.furrano:0x00000201r, "RR suspension" );
		addPart( cars.cat_04.furrano:0x00000205r, "RL suspension" );

		if ( optical < 1.0 )
		{
			addPart( parts.wheels_combo:0x000000B0r, "wheel" );
			addPart( parts.wheels_combo:0x000000B0r, "wheel" );
			addPart( parts.wheels_combo:0x000000B1r, "wheel" );
			addPart( parts.wheels_combo:0x000000B1r, "wheel" );

		} else
		{
			if ( random() > 0.5 ) // SI//
			{
				if ( (power+optical)*0.5 >= 1.666 ) // 255-21F 375-21R //
				{
					addPart( parts.wheels_combo:0x00000BB3r, "wheel" );
					addPart( parts.wheels_combo:0x00000BB3r, "wheel" );
					addPart( parts.wheels_combo:0x00000BB5r, "wheel" );
					addPart( parts.wheels_combo:0x00000BB5r, "wheel" );
				} else
				if ( (power+optical)*0.5 >= 1.333 ) // 255-21F 315-21R //
				{
					addPart( parts.wheels_combo:0x00000BB3r, "wheel" );
					addPart( parts.wheels_combo:0x00000BB3r, "wheel" );
					addPart( parts.wheels_combo:0x00000BB4r, "wheel" );
					addPart( parts.wheels_combo:0x00000BB4r, "wheel" );
				} else                             // 255-19F 315-19R //
				{
					addPart( parts.wheels_combo:0x000000B3r, "wheel" );
					addPart( parts.wheels_combo:0x000000B3r, "wheel" );
					addPart( parts.wheels_combo:0x000000B4r, "wheel" );
					addPart( parts.wheels_combo:0x000000B4r, "wheel" );
				}
			} else
			if ( random() > 0.5 ) // Sparkler //
			{
				if ( (power+optical)*0.5 >= 1.666 ) // 255-21F 375-21R //
				{
					addPart( parts.wheels_combo:0x00000BB6r, "wheel" );
					addPart( parts.wheels_combo:0x00000BB6r, "wheel" );
					addPart( parts.wheels_combo:0x00000BB8r, "wheel" );
					addPart( parts.wheels_combo:0x00000BB8r, "wheel" );
				} else
				if ( (power+optical)*0.5 >= 1.333 ) // 255-21F 315-21R //
				{
					addPart( parts.wheels_combo:0x00000BB6r, "wheel" );
					addPart( parts.wheels_combo:0x00000BB6r, "wheel" );
					addPart( parts.wheels_combo:0x00000BB7r, "wheel" );
					addPart( parts.wheels_combo:0x00000BB7r, "wheel" );
				} else                             // 255-19F 315-19R //
				{
					addPart( parts.wheels_combo:0x000000B6r, "wheel" );
					addPart( parts.wheels_combo:0x000000B6r, "wheel" );
					addPart( parts.wheels_combo:0x000000B7r, "wheel" );
					addPart( parts.wheels_combo:0x000000B7r, "wheel" );
				}
			} else                // Chromo //
			{
				if ( (power+optical)*0.5 >= 1.666 ) // 255-21F 375-21R //
				{
					addPart( parts.wheels_combo:0x00000BAAr, "wheel" );
					addPart( parts.wheels_combo:0x00000BAAr, "wheel" );
					addPart( parts.wheels_combo:0x00000BACr, "wheel" );
					addPart( parts.wheels_combo:0x00000BACr, "wheel" );
				} else
				if ( (power+optical)*0.5 >= 1.333 ) // 255-21F 315-21R //
				{
					addPart( parts.wheels_combo:0x00000BAAr, "wheel" );
					addPart( parts.wheels_combo:0x00000BAAr, "wheel" );
					addPart( parts.wheels_combo:0x00000BABr, "wheel" );
					addPart( parts.wheels_combo:0x00000BABr, "wheel" );
				} else                             // 255-19F 315-19R //
				{
					addPart( parts.wheels_combo:0x000000AAr, "wheel" );
					addPart( parts.wheels_combo:0x000000AAr, "wheel" );
					addPart( parts.wheels_combo:0x000000ABr, "wheel" );
					addPart( parts.wheels_combo:0x000000ABr, "wheel" );
				}
			}
		}

		if ( power >= 1.4 ) // Bilstein pro racer //
		{
			addPart( parts.running_gear:0x000001F8r, "shock" );
			addPart( parts.running_gear:0x000001F8r, "shock" );
			addPart( parts.running_gear:0x000001F9r, "shock" );
			addPart( parts.running_gear:0x000001F9r, "shock" );
		} else
		if ( power >= 1.2 ) // Bilstein street racer //
		{
			addPart( parts.running_gear:0x000001F6r, "shock" );
			addPart( parts.running_gear:0x000001F6r, "shock" );
			addPart( parts.running_gear:0x000001F7r, "shock" );
			addPart( parts.running_gear:0x000001F7r, "shock" );
		} else
		if ( power >= 1.1 ) // Bilstein aftermarket //
		{
			addPart( parts.running_gear:0x000001EFr, "shock" );
			addPart( parts.running_gear:0x000001EFr, "shock" );
			addPart( parts.running_gear:0x000001F0r, "shock" );
			addPart( parts.running_gear:0x000001F0r, "shock" );
		} else                // stock //
		{
			addPart( parts.running_gear:0x000011FFr, "shock" );
			addPart( parts.running_gear:0x000011FFr, "shock" );
			addPart( parts.running_gear:0x000012FFr, "shock" );
			addPart( parts.running_gear:0x000012FFr, "shock" );
		}

		if ( power >= 1.5 ) // H&R pro racer 56000 Nm 13" //
		{
			addPart( parts.running_gear:0x00000217r, "spring" );
			addPart( parts.running_gear:0x00000217r, "spring" );
			addPart( parts.running_gear:0x00000218r, "spring" );
			addPart( parts.running_gear:0x00000218r, "spring" );
		} else              // H&R aftermarket 40000 Nm 14" //
		{
			addPart( parts.running_gear:0x00000219r, "spring" );
			addPart( parts.running_gear:0x00000219r, "spring" );
			addPart( parts.running_gear:0x0000021Ar, "spring" );
			addPart( parts.running_gear:0x0000021Ar, "spring" );
		}

		if ( power >= 1.3 ) // Baer carbon 12.5"F 13.0"R //
		{
			addPart( parts.running_gear:0x000000E2r, "FL brake" );
			addPart( parts.running_gear:0x000000E5r, "FR brake" );
			addPart( parts.running_gear:0x000000FAr, "RL brake" );
			addPart( parts.running_gear:0x000000FFr, "RR brake" );
		} else
		if ( power >= 1.15 ) // Baer grooved 12.5"F 12.5"R //
		{
			addPart( parts.running_gear:0x00000147r, "FL brake" );
			addPart( parts.running_gear:0x00000149r, "FR brake" );
			addPart( parts.running_gear:0x0000014Cr, "RL brake" );
			addPart( parts.running_gear:0x0000014Er, "RR brake" );
		} else              // Baer drilled 12.5"F 12.5"R //
		{
			addPart( parts.running_gear:0x00000108r, "FL brake" );
			addPart( parts.running_gear:0x00000132r, "FR brake" );
			addPart( parts.running_gear:0x00000136r, "RL brake" );
			addPart( parts.running_gear:0x00000146r, "RR brake" );
		}

		if ( power >= 1.25 ) // supersport //
		{
			addPart( parts.running_gear:0x00000164r, "F swaybar" );
			addPart( parts.running_gear:0x00000181r, "R swaybar" );
		} else              // sport //
		{
			addPart( parts.running_gear:0x00000154r, "F swaybar" );
			addPart( parts.running_gear:0x0000015Cr, "R swaybar" );
		}

		if ( power >= 1.75 ) addPart( parts.engines.V10:0x0000000Ar, "8.4L copper coated V10 engine", actcolor, optical, (power-1.75)/0.25*2 ); else
		if ( power >= 1.5 ) addPart( parts.engines.V10:0x00000009r, "7.1L copper coated V10 engine", actcolor, optical, (power-1.5)/0.25*2 ); else
		if ( power >= 1.25 ) addPart( parts.engines.V10:0x00000008r, "6.8L alloy V10 engine", actcolor, optical, (power-1.25)/0.25*2 ); else
		if ( power >= 1 ) addPart( parts.engines.V10:0x00000007r, "5.9L alloy V10 engine", actcolor, optical, (power-1)/0.25*2 );

		if ( optical <= 1.0 )
		{
			if ( optical >= random() ) addPart( cars.cat_04.furrano:0x000000B5r, "hood", actcolor, optical, power );
		} else
		{
			part_random = random();
			if ( optical-1 >= 0.66667 ) addPart( cars.cat_04.furrano:0x0000A0C2r, "hood 3", actcolor, optical, power ); else
			if ( optical-1 >= 0.33333 ) addPart( cars.cat_04.furrano:0x000000C2r, "hood 2", actcolor, optical, power ); else
			addPart( cars.cat_04.furrano:0x000000B5r, "hood", actcolor, optical, power );
		}

		if ( power >= 1.35 ) addPart( parts:0x000000E9r, "silver battery" ); else
		addPart( parts:0x000000E8r, "blue battery" );
		
		addPart( cars.cat_04.Furrano:0x000000B4r, "steering_wheel" );
	}
	
	public void setDrive(int fwd, int rwd, float drive_front)
	{
		if((fwd && !rwd) || (rwd && !fwd)) super.setDrive(0,1,0.0); //2WD all becomes RWD
		else super.setDrive(fwd, rwd, drive_front); //Leave AWD alone 
	}
}